//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "ZylCustomGPSReceiver"
#pragma link "ZylUdpGPSReceiver"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnStartClick(TObject *Sender)
{
  try
  {
    cmpZylGPSReceiver->Port = StrToInt(efPort->Text);
    cmpZylGPSReceiver->Open();
  }
  catch (...)
  {
    ShowMessage("Wrong port.");
  }
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::btnStopClick(TObject *Sender)
{
  cmpZylGPSReceiver->Close();
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverConnect(TObject *Sender,
      int Port)
{
  memRaw->Lines->Add("Connected to:" + IntToStr(Port));
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverDisconnect(TObject *Sender,
      int Port)
{
  memRaw->Lines->Add("Disconnected from:" + IntToStr(Port));
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverSpeedChange(TObject *Sender,
      Extended Value)
{
  memRaw->Lines->Add("Speed Changed:" + FloatToStr(Value) + " KM/H");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverReceive(TObject *Sender)
{
  efLatDeg->Text = IntToStr(cmpZylGPSReceiver->GetLatitudeDegree());
  efLatMin->Text = IntToStr(cmpZylGPSReceiver->GetLatitudeMinute());
  efLatSec->Text = FloatToStr(cmpZylGPSReceiver->GetLatitudeSecond());
  if (cmpZylGPSReceiver->GetLatitudeDirection() == cpNorth)
    efLatDir->Text = "North";
  else
    efLatDir->Text = "South";

  efLongDeg->Text = IntToStr(cmpZylGPSReceiver->GetLongitudeDegree());
  efLongMin->Text = IntToStr(cmpZylGPSReceiver->GetLongitudeMinute());
  efLongSec->Text = FloatToStr(cmpZylGPSReceiver->GetLongitudeSecond());
  if (cmpZylGPSReceiver->GetLongitudeDirection() == cpEast)
    efLongDir->Text = "East";
  else
    efLongDir->Text = "West";

  efAlt->Text = FloatToStr(cmpZylGPSReceiver->GetAltitude());
  efSpeed->Text = FloatToStr(cmpZylGPSReceiver->GetSpeed_KMH());
  efHeading->Text = FloatToStr(cmpZylGPSReceiver->GetHeading());
  efSatCount->Text = IntToStr(cmpZylGPSReceiver->GetSatelliteCount());

  try
  {
    memRaw->Lines->Add(cmpZylGPSReceiver->GetRawData());
  }
  catch(...)
  {
    memRaw->Lines->Clear();
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiver2DPositionChange(TObject *Sender,
      Extended Latitude, Extended Longitude)
{
  memRaw->Lines->Add("2D Position Changed. Distance to New York City = " + FloatToStr(cmpZylGPSReceiver->Distance_KM(Latitude, Longitude, 40.77, 73.98)) + " KM");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiver3DPositionChange(TObject *Sender,
      Extended Latitude, Extended Longitude, Extended Altitude)
{
  memRaw->Lines->Add("3D Position Changed.");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverAltitudeChange(TObject *Sender,
      Extended Value)
{
  memRaw->Lines->Add("Altitude Changed:" + FloatToStr(Value) + " M");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverHeadingChange(TObject *Sender,
      Extended Value)
{
  memRaw->Lines->Add("Heading Changed:" + FloatToStr(Value) + " Degrees");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverLatitudeChange(TObject *Sender,
      int Degree, int Minute, Extended Second, TCardinalPoint Direction)
{
  memRaw->Lines->Add("Latitude Changed.");         
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ZylGPSReceiverLongitudeChange(TObject *Sender,
      int Degree, int Minute, Extended Second, TCardinalPoint Direction)
{
  memRaw->Lines->Add("Longitude Changed.");        
}
//---------------------------------------------------------------------------

